/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.widget;

import icyllis.modernui.view.View;
import icyllis.modernui.view.ViewGroup;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AbsoluteLayout
extends ViewGroup {
    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int count = this.getChildCount();
        int maxWidth = 0;
        int maxHeight = 0;
        this.measureChildren(widthMeasureSpec, heightMeasureSpec);
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 2) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int childRight = lp.x + child.getMeasuredWidth();
            int childBottom = lp.y + child.getMeasuredHeight();
            maxWidth = Math.max(maxWidth, childRight);
            maxHeight = Math.max(maxHeight, childBottom);
        }
        maxWidth = Math.max(maxWidth, this.getMinWidth());
        maxHeight = Math.max(maxHeight, this.getMinHeight());
        this.setMeasuredDimension(AbsoluteLayout.resolveSize(maxWidth, widthMeasureSpec), AbsoluteLayout.resolveSize(maxHeight, heightMeasureSpec));
    }

    @Override
    protected void onLayout(boolean changed) {
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 2) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            child.layout(lp.x, lp.y, lp.x + child.getMeasuredWidth(), lp.y + child.getMeasuredHeight());
        }
    }

    @Override
    @Nonnull
    protected ViewGroup.LayoutParams convertLayoutParams(@Nonnull ViewGroup.LayoutParams params) {
        if (params instanceof LayoutParams) {
            return params;
        }
        return new LayoutParams(params);
    }

    @Override
    @Nonnull
    protected ViewGroup.LayoutParams createDefaultLayoutParams() {
        return new LayoutParams(-2, -2, 0, 0);
    }

    @Override
    protected boolean checkLayoutParams(@Nullable ViewGroup.LayoutParams params) {
        return params instanceof LayoutParams;
    }

    public static class LayoutParams
    extends ViewGroup.LayoutParams {
        public int x;
        public int y;

        public LayoutParams(int width, int height, int x, int y) {
            super(width, height);
            this.x = x;
            this.y = y;
        }

        public LayoutParams(@Nonnull ViewGroup.LayoutParams source) {
            super(source);
        }

        public LayoutParams(LayoutParams source) {
            super(source);
            this.x = source.x;
            this.y = source.y;
        }

        @Override
        @Nonnull
        public LayoutParams copy() {
            return new LayoutParams(this);
        }
    }
}

